/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWInvokeInstruction;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.property.VWInvokeParamPanel;
import filenet.vw.toolkit.runtime.property.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class VWInvokeCorrelationSetPanel
extends JPanel {
    public static final int NUM_COLUMNS = 2;
    public static final int COL_NAME = 0;
    public static final int COL_XPATH_QUERY_STRING = 1;
    private VWInvokeParamPanel m_parent = null;
    private DefaultTableCellRenderer m_tableCellRenderer = null;
    private VWInstructionDefinition m_instructionDef = null;
    private JPanel m_outgoingMsgPanel = null;
    private JPanel m_incomingMsgPanel = null;
    private JTabbedPane m_tabs = null;
    private String[] m_paramsTableColumnNames = new String[]{VWResource.s_name, VWResource.s_xpathQueryString};
    private String[][] m_incomingParams = null;
    private JTextField m_incomingName = null;
    private VWTable m_incomingParamsTable = null;
    private AbstractTableModel m_incomingParamsTableModel = null;
    private String[][] m_outgoingParams = null;
    private JTextField m_outgoingName = null;
    private VWTable m_outgoingParamsTable = null;
    private AbstractTableModel m_outgoingParamsTableModel = null;

    public VWInvokeCorrelationSetPanel(VWInvokeParamPanel parent, DefaultTableCellRenderer tableCellRenderer, VWInstructionDefinition instruction) {
        this.m_parent = parent;
        this.m_tableCellRenderer = tableCellRenderer;
        this.m_instructionDef = instruction;
        this.setupLayout();
    }

    public void setInstructionDefinition(VWInvokeInstruction instructionDef) {
        this.m_instructionDef = instructionDef;
        this.reinitialize();
    }

    private void setupLayout() {
        this.setLayout(new GridBagLayout());
        this.m_outgoingMsgPanel = this.createIncomingMessagePanel();
        this.m_incomingMsgPanel = this.createOutgoingMessagePanel();
        this.m_tabs = new JTabbedPane();
        this.m_tabs.add(VWResource.s_outgoingMessage, this.m_outgoingMsgPanel);
        this.m_tabs.add(VWResource.s_incomingMessage, this.m_incomingMsgPanel);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 23;
        c.gridwidth = 0;
        c.fill = 1;
        this.add((Component)this.m_tabs, c);
    }

    private JPanel createIncomingMessagePanel() {
        JLabel nameLabel = new JLabel(VWResource.s_nameColon);
        this.m_incomingName = new JTextField();
        this.m_incomingName.setEditable(false);
        this.m_incomingName.setBorder(null);
        JPanel namePanel = new JPanel(new BorderLayout(10, 0));
        namePanel.add((Component)nameLabel, "Before");
        namePanel.add((Component)this.m_incomingName, "Center");
        VWToolbarBorder paramsBorder = new VWToolbarBorder(VWResource.s_properties, 0);
        JPanel paramsPanel = paramsBorder.getClientPanel();
        paramsPanel.setLayout(new BorderLayout());
        paramsPanel.setBorder(BorderFactory.createEtchedBorder());
        this.m_incomingParamsTable = new VWTable();
        this.m_incomingParamsTable.setRowSelectionAllowed(true);
        this.m_incomingParamsTable.setColumnSelectionAllowed(false);
        this.m_incomingParamsTable.setSelectionMode(0);
        paramsPanel.add((Component)new JScrollPane(this.m_incomingParamsTable), "Center");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 23;
        c.gridwidth = 0;
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        c.fill = 2;
        panel.add((Component)namePanel, c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        panel.add((Component)paramsBorder, c);
        return panel;
    }

    private JPanel createOutgoingMessagePanel() {
        JLabel nameLabel = new JLabel(VWResource.s_nameColon);
        this.m_outgoingName = new JTextField();
        this.m_outgoingName.setEditable(false);
        this.m_outgoingName.setBorder(null);
        JPanel namePanel = new JPanel(new BorderLayout(10, 0));
        namePanel.add((Component)nameLabel, "Before");
        namePanel.add((Component)this.m_outgoingName, "Center");
        VWToolbarBorder paramsBorder = new VWToolbarBorder(VWResource.s_properties, 0);
        JPanel paramsPanel = paramsBorder.getClientPanel();
        paramsPanel.setLayout(new BorderLayout());
        paramsPanel.setBorder(BorderFactory.createEtchedBorder());
        this.m_outgoingParamsTable = new VWTable();
        this.m_outgoingParamsTable.setRowSelectionAllowed(true);
        this.m_outgoingParamsTable.setColumnSelectionAllowed(false);
        this.m_outgoingParamsTable.setSelectionMode(0);
        paramsPanel.add((Component)new JScrollPane(this.m_outgoingParamsTable), "Center");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 23;
        c.gridwidth = 0;
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        c.fill = 2;
        panel.add((Component)namePanel, c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        panel.add((Component)paramsBorder, c);
        return panel;
    }

    private void reinitialize() {
        try {
            this.m_incomingParamsTableModel = null;
            this.m_outgoingParamsTableModel = null;
            String incomingName = ((VWInvokeInstruction)this.m_instructionDef).getInputCorrelationSetName();
            this.m_incomingName.setText(incomingName);
            String outgoingName = ((VWInvokeInstruction)this.m_instructionDef).getOutputCorrelationSetName();
            this.m_outgoingName.setText(outgoingName);
            this.m_incomingParams = ((VWInvokeInstruction)this.m_instructionDef).getInputCorrelationSetProperties();
            if (this.m_incomingParams != null) {
                if (this.m_incomingParamsTableModel == null) {
                    this.m_incomingParamsTableModel = new AbstractTableModel(){

                        public boolean isCellEditable(int row, int col) {
                            return false;
                        }

                        public String getColumnName(int nColumnIndex) {
                            switch (nColumnIndex) {
                                case 0: {
                                    return VWInvokeCorrelationSetPanel.this.m_paramsTableColumnNames[0];
                                }
                                case 1: {
                                    return VWInvokeCorrelationSetPanel.this.m_paramsTableColumnNames[1];
                                }
                            }
                            return null;
                        }

                        public int getColumnCount() {
                            return VWInvokeCorrelationSetPanel.this.m_paramsTableColumnNames.length;
                        }

                        public int getRowCount() {
                            if (VWInvokeCorrelationSetPanel.this.m_incomingParams != null) {
                                return VWInvokeCorrelationSetPanel.this.m_incomingParams.length;
                            }
                            return 0;
                        }

                        public Object getValueAt(int nRowIndex, int nColumnIndex) {
                            try {
                                if (VWInvokeCorrelationSetPanel.this.m_incomingParams != null && nRowIndex >= 0 && nRowIndex < VWInvokeCorrelationSetPanel.this.m_incomingParams.length) {
                                    String[] paramDef = VWInvokeCorrelationSetPanel.this.m_incomingParams[nRowIndex];
                                    if (paramDef == null) {
                                        return null;
                                    }
                                    switch (nColumnIndex) {
                                        case 0: {
                                            return paramDef[0];
                                        }
                                        case 1: {
                                            return paramDef[1];
                                        }
                                    }
                                }
                            }
                            catch (Exception ex) {
                                VWDebug.logException(ex);
                            }
                            return null;
                        }
                    };
                    this.m_incomingParamsTable.setModel(this.m_incomingParamsTableModel);
                }
                this.m_parent.setupTableCellRenderer(this.m_incomingParamsTable, this.m_incomingParamsTableModel);
                this.m_incomingParamsTableModel.fireTableDataChanged();
                this.m_incomingParamsTable.fitColumnsInTable();
                this.m_incomingParamsTable.updateUI();
            }
            this.m_outgoingParams = ((VWInvokeInstruction)this.m_instructionDef).getOutputCorrelationSetProperties();
            if (this.m_outgoingParams != null) {
                if (this.m_outgoingParamsTableModel == null) {
                    this.m_outgoingParamsTableModel = new AbstractTableModel(){

                        public boolean isCellEditable(int row, int col) {
                            return false;
                        }

                        public String getColumnName(int nColumnIndex) {
                            switch (nColumnIndex) {
                                case 0: {
                                    return VWInvokeCorrelationSetPanel.this.m_paramsTableColumnNames[0];
                                }
                                case 1: {
                                    return VWInvokeCorrelationSetPanel.this.m_paramsTableColumnNames[1];
                                }
                            }
                            return null;
                        }

                        public int getColumnCount() {
                            return VWInvokeCorrelationSetPanel.this.m_paramsTableColumnNames.length;
                        }

                        public int getRowCount() {
                            if (VWInvokeCorrelationSetPanel.this.m_outgoingParams != null) {
                                return VWInvokeCorrelationSetPanel.this.m_outgoingParams.length;
                            }
                            return 0;
                        }

                        public Object getValueAt(int nRowIndex, int nColumnIndex) {
                            try {
                                if (VWInvokeCorrelationSetPanel.this.m_outgoingParams != null && nRowIndex >= 0 && nRowIndex < VWInvokeCorrelationSetPanel.this.m_outgoingParams.length) {
                                    String[] paramDef = VWInvokeCorrelationSetPanel.this.m_outgoingParams[nRowIndex];
                                    if (paramDef == null) {
                                        return null;
                                    }
                                    switch (nColumnIndex) {
                                        case 0: {
                                            return paramDef[0];
                                        }
                                        case 1: {
                                            return paramDef[1];
                                        }
                                    }
                                }
                            }
                            catch (Exception ex) {
                                VWDebug.logException(ex);
                            }
                            return null;
                        }
                    };
                    this.m_outgoingParamsTable.setModel(this.m_outgoingParamsTableModel);
                }
                this.m_parent.setupTableCellRenderer(this.m_outgoingParamsTable, this.m_outgoingParamsTableModel);
                this.m_outgoingParamsTableModel.fireTableDataChanged();
                this.m_outgoingParamsTable.fitColumnsInTable();
                this.m_outgoingParamsTable.updateUI();
            }
            this.updateUI();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void removeReferences() {
        int i;
        this.m_incomingMsgPanel = null;
        this.m_outgoingMsgPanel = null;
        this.m_tabs = null;
        this.m_incomingName = null;
        this.m_outgoingName = null;
        for (i = 0; i < this.m_paramsTableColumnNames.length; ++i) {
            this.m_paramsTableColumnNames[i] = null;
        }
        if (this.m_incomingParams != null) {
            for (i = 0; i < this.m_incomingParams.length; ++i) {
                this.m_incomingParams[i] = null;
            }
        }
        if (this.m_incomingParamsTable != null) {
            this.m_incomingParamsTable.removeReferences();
            this.m_incomingParamsTable = null;
        }
        this.m_incomingParamsTableModel = null;
        if (this.m_outgoingParams != null) {
            for (i = 0; i < this.m_outgoingParams.length; ++i) {
                this.m_outgoingParams[i] = null;
            }
        }
        if (this.m_outgoingParamsTable != null) {
            this.m_outgoingParamsTable.removeReferences();
            this.m_outgoingParamsTable = null;
        }
        this.m_outgoingParamsTableModel = null;
        this.m_parent = null;
        this.m_tableCellRenderer = null;
        this.m_instructionDef = null;
    }
}

